cp_85362(QUATERNION) { 
/*  Copyright Matthew Benesi   All Rights Reserved  */
/*  These formulas are only authorized for distribution with ChaosPro */
/*  Derivative works may not be distributed without authors permission   */
/*  2/28/2011 */
parameter real bailout,seed;
parameter quaternion perturb;
parameter quaternion c;
real sx,sx2,sy,sy2,sz,sz2,sw,sv,su;
real nx,nx2,ny,ny2,nz,nz2,nw,nv,nu;
real r,r1,r2,r3,r4,a,b,d,bail;
parameter int fractaltype,bmode,amode;  //  pixelstretch  
parameter int pixelmode,symmetrymode,colortime;
complex victor,bravo,cramden,ralph;
real cr,ci,cj,ck,cw,cv,cu,i,sr2i;
real checkvar,theta,phi,tango,whiskey,foxtrot,gamma;
real pixelr,pixeli,pixelj,pixelw,pixelmag,pixelv,pixelu;
parameter real n,pixeln,checkvarset,checkvarsetA,spokes;
parameter bool addyzpixel,juliaMode,radswitch;
parameter bool Detail_Switch,inversebailout,xchange,exp1,exp2;
	void init(void)
	{   // amode and colormodeB are switched for mag vs. xyz before march 12 2011
			sr2i=sqrt(.5);
			if (bmode=="Pi/2") {
				b=pi/2;
			} else if (bmode=="Root 2") {
				b=sqrt(2);
			} else if (bmode=="Golden Ratio"){
				b=(1+sqrt(5))/2;
			} else if (bmode=="Variable"){
				b=checkvarset;
			}
			
				checkvar=(n)*b;
			
			if (amode=="b^(3-n)") {
				a=b^(3-n);
			} else if (amode=="b*(n-1)^-1") {
				a=b*(n-1)^-1;
			} else if (amode=="Variable") {
				a=checkvarsetA;
			}
	
		
		
		cr=part_r(c);
		ci=part_i(c);
		cj=part_j(c);
		ck=part_k(c);
		
		if (pixelmode=="+ no abs") {
			pixelr=part_r(pixel);
			pixeli=part_i(pixel);
			pixelj=part_j(pixel);
		} 
		  else if (pixelmode=="- no abs") {
			pixelr=-part_r(pixel);
			pixeli=-part_i(pixel);
			pixelj=-part_j(pixel);
		} else if (pixelmode=="+y abs") {
			pixelr=part_r(pixel);
			pixeli=abs(part_i(pixel));
			pixelj=part_j(pixel);
		} else if (pixelmode=="-y abs") {
			pixelr=part_r(pixel);
			pixeli=-abs(part_i(pixel));
			pixelj=part_j(pixel);
		} else if (pixelmode=="+z abs") {
			pixelr=part_r(pixel);
			pixeli=(part_i(pixel));
			pixelj=abs(part_j(pixel));
		} else if (pixelmode=="-z abs") {
			pixelr=part_r(pixel);
			pixeli=(part_i(pixel));
			pixelj=-abs(part_j(pixel));
		} else if (pixelmode=="+y +z abs") {
			pixelr=part_r(pixel);
			pixeli=abs(part_i(pixel));
			pixelj=abs(part_j(pixel));
		} else if (pixelmode=="-y +z abs") {
			pixelr=part_r(pixel);
			pixeli=-abs(part_i(pixel));
			pixelj=abs(part_j(pixel));
		} else if (pixelmode=="-y -z abs") {
			pixelr=part_r(pixel);
			pixeli=-abs(part_i(pixel));
			pixelj=-abs(part_j(pixel));
		} else if  (pixelmode=="+y -z abs") {
			pixelr=part_r(pixel);
			pixeli=abs(part_i(pixel));
			pixelj=-abs(part_j(pixel));
		} else if  (pixelmode=="-x -y -z abs") {
			pixelr=-abs(part_r(pixel));
			pixeli=-abs(part_i(pixel));
			pixelj=-abs(part_j(pixel));
		} else if  (pixelmode=="+x +y +z abs") {
			pixelr=abs(part_r(pixel));
			pixeli=abs(part_i(pixel));
			pixelj=abs(part_j(pixel));
		}
			pixelmag=cabs(pixel);
			
		/*  //TO ENABLE PIXELSTRETCH, WHICH I haven't fixed as of yet
		    // you need to uncomment this section, and the section
			 // in the "description" part of this formula
			 // Also, you need to add a pixelstretch "int" type
			 // parameter in the parameter/variables declaration
			 // at the top of this formula
			  	
			 if (pixelstretch=="Stretch 1") {
			//second rotation attempt- x vs mag yz
			r2=sqr(pixeli)+sqr(pixelj);
			r1=sqrt(sqr(pixelr)+r2);
			r2=sqrt(r2);
			theta=atan2(pixelr+flip(r2));
			phi=atan2(pixeli+flip(pixelj));
			
			theta=(theta+pi)*.5;
			
			pixelr=cos(theta)*r1;
			pixeli=sin(theta)*cos(phi)*r1;
			pixelj=sin(theta)*sin(phi)*r1;
		}    else if (pixelstretch=="Stretch 2") {
		
			//second rotation attempt- x vs mag yz
			r2=sqr(pixeli)+sqr(pixelj);
			r1=sqrt(sqr(pixelr)+r2);
			r2=sqrt(r2);
			theta=atan2(pixelr+flip(r2));
			phi=atan2(pixeli+flip(pixelj));
			
			if (abs(theta)<pi/2) {
				theta=(theta+pi/2)*1.25;
			} else {
				theta=(theta+pi)*.5;
			}
			pixelr=cos(theta)*r1;
			pixeli=sin(theta)*cos(phi)*r1;
			pixelj=sin(theta)*sin(phi)*r1;
		}
		//      */
		
	if (fractaltype=="mag vs xyz" || fractaltype=="mag vs xyz 2"  ||fractaltype=="Mag Mandy 1"  || fractaltype == "Mag Mandy 2 fast" ) {
		
			if (spokes==3) {
				
			
			//rotation around y axis, no y rotation
			
			//foxtrot=(90-54.7356)/180*pi;
			whiskey=sqrt(2/3);   // cos((foxtrot));
			tango= sqrt(1/3);   //sin((foxtrot));
 
			pixelv= pixelr  * whiskey - pixelj * tango;
			pixelj= pixelr  * tango     +  pixelj * whiskey;
			pixelr=pixelv;
				
				//rotation around z axis, no z rotation
			//  foxtrot=45/180*pi;
			whiskey= sqrt(.5);  // cos((foxtrot));
			tango= whiskey;  //sin((foxtrot));
			
			pixelv=pixelr*whiskey-pixeli*tango;
			pixeli=pixelr*tango+pixeli*whiskey;
			pixelr=pixelv;
		}  else  {
		
			//spokes
			theta=atan2(pixeli+flip(pixelj));
			if (theta>0) {
				theta=(theta*spokes)*1/3;    
			} else {            
				theta=(theta*spokes)*1/3;
			}
			r1=sqrt(sqr(pixeli)+sqr(pixelj));
			pixeli=cos(theta)*r1;
			pixelj=sin(theta)*r1;
			
	
			//rotation around x axis, no x rotation
			 
			//foxtrot=30/180*pi;
			whiskey= sqrt(3/4); //cos((foxtrot));
			tango= .5;  //sin((foxtrot));
			
			pixelv=pixeli*whiskey+pixelj*tango;
			pixelj=-pixeli*tango+pixelj*whiskey;
			pixeli=pixelv;
			
			//rotation around y axis, no y rotation
			
			//foxtrot=(90-54.7356)/180*pi;
			whiskey=sqrt(2/3); // cos((foxtrot));
			tango= sqrt(1/3);  //sin((foxtrot));
		
			pixelv= pixelr  * whiskey - pixelj * tango;
			pixelj= pixelr  * tango     +  pixelj * whiskey;
			pixelr=pixelv;
		
				//rotation around z axis, no z rotation
			//foxtrot=45/180*pi;
			whiskey= sqrt(.5); //cos((foxtrot));
			tango=whiskey; // sin((foxtrot));
			
			pixelv=pixelr*whiskey-pixeli*tango;
			pixeli=pixelr*tango+pixeli*whiskey;
			pixelr=pixelv;
		} 
		
	} else if (spokes==2 || spokes==6 || spokes==10) {
			//rotation around x axis, no x rotation
			 
			//foxtrot=30/180*pi;
			foxtrot=sqrt(2);
			whiskey= sqrt(2+sqrt(2))/2; //cos((foxtrot));
			tango= sqrt(2-sqrt(2))/2;  //sin((foxtrot));
			
			pixelv=pixeli*whiskey+pixelj*tango;
			pixelj=-pixeli*tango+pixelj*whiskey;
			pixeli=pixelv;
	}   else if (spokes==4 || spokes==8 || spokes==12) {
			//rotation around x axis, no x rotation
			 
			//foxtrot=30/180*pi;
			foxtrot=sqrt(2+sqrt(2));
			whiskey= sqrt(2+foxtrot)/2; //cos((foxtrot));
			tango= sqrt(2-foxtrot)/2;  //sin((foxtrot));
			
			pixelv=pixeli*whiskey+pixelj*tango;
			pixelj=-pixeli*tango+pixelj*whiskey;
			pixeli=pixelv;
	}
		
		if (juliaMode) {
			sx=pixelr;
			sy=pixeli;
			sz=pixelj;
		} else {
			if (fractaltype=="Mandy Mag 2 fast" || fractaltype=="Mag Mandy Actual Pixel" || fractaltype=="Mag Mandy 1" || fractaltype== "Mandy Mag 1"  || fractaltype == "Mag Mandy 2 fast") {
				sx=pixelr;
				sy=pixeli;
				sz=pixelj;
				sw=0;
			} else {
				sx=cr;
				sy=ci;
				sz=cj;
				sw=ck;
			}
		}
		
		
	}
	void loop(void)
	{	
	 if (fractaltype=="Mag Mandy 1") {
			if (radswitch) {
					r=(abs(abs(sx)*sx+sy*abs(sy)+sz*abs(sz)));
					r1=(sqr(sx)*a+r)^abs(pixeln/2);
					r2=(sqr(sy)*a+r)^abs(pixeln/2);
					r3=(sqr(sz)*a+r)^abs(pixeln/2);
					r=sqrt(r);
				} else {
					r=(sqr(sx)+sqr(sy)+sqr(sz));
					r1=(sqr(sx)*a+r)^abs(pixeln/2);
					r2=(sqr(sy)*a+r)^abs(pixeln/2);
					r3=(sqr(sz)*a+r)^abs(pixeln/2);
					r=sqrt(r);
				}
			
			
			theta=atan2(abs(sx)*checkvar+flip(r));
			phi=atan2(abs(sy)*checkvar+flip(r));
			tango=atan2(abs(sz)*checkvar+flip(r));
			
			sx=r1*cos(theta*pixeln) +seed;
			sy=r2*cos(phi*pixeln) +seed;
			sz=r3*cos(tango*pixeln)+seed;
			if (colortime=="Post Mag Pre Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			// rotate towards mandy type
	
				//rotation around z axis, no z rotation
			foxtrot=-45/180*pi;
			whiskey= cos((foxtrot));
			tango= sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			ny=sx*tango+sy*whiskey;
			sx=nx;
			sy=ny;
			
			//rotation around y axis, no y rotation

			foxtrot=-(90-54.7356)/180*pi;
			whiskey= cos((foxtrot));
			tango= sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			nz= sx  * tango     +  sz * whiskey;
			sx=nx;
			sz=nz;
			
		
		if (spokes!=3) {
			theta=atan2(sy+flip(sz));
			if (theta>0) {
				theta=(theta/spokes)*3;   // +pi/2  * 4/3
			} else {           //  (theta +pi/x)* 2/3*x
				theta=(theta/spokes)*3;
			}
			r1=sqrt(sqr(sy)+sqr(sz));
			sy=cos(theta)*r1;
			sz=sin(theta)*r1;
		}	
			if (colortime=="Post Mag Post Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			//mandy start  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			if (symmetrymode=="YZ Switch     very nice") {
				
				r2=(sqr(sx)+sqr(sy)+sqr(sz))^abs(n/2);
			
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz))));
				phi=atan2((sy)+flip((sz)));
				
				theta=n*theta;
				phi=n*phi;
				nx=r2*cos(theta);
				nz=(r2*cos(phi)*sin (theta));
				ny=(r2*sin(phi)*sin (theta));
			} else if (symmetrymode!="YZ Switch     very nice") {
				r2=(sqr(sx)+sqr(sy)+sqr(sz))^abs(n/2);
			
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz))));
				phi=atan2((sy)+flip((sz)));
				
				theta=n*theta;
				phi=n*phi;
				nx=r2*cos(theta);
				ny=r2*cos(phi)*sin (theta);
				nz=r2*sin(phi)*sin (theta);
			}
			if (Detail_Switch) {
				if (n==2 || n==6) {
					if (part_r(pixel)>0 && sx>sqrt(sqr(sy)+sqr(sz))) {
							nx=-nx;
						}
				} else if (n==3 || n==5  || n==7 || n==9) {
					if (sx>0) {
							nx=-nx;
						}
				}
			}
			if (juliaMode) {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;	
			} else {
				if(addyzpixel) {
						if (part_r(pixel)<0) {
							sx=nx+1*part_r(pixel);
						} else {
							sx=nx+.5*part_r(pixel);
						}
						sy=ny+.25*(part_i(pixel));
						sz=nz+.25*(part_j(pixel));
					} else  {
						if (part_r(pixel)<0) {
							sx=nx+part_r(pixel);
						} else {
							sx=nx+part_r(pixel)*.5;
						}
					sy=ny;
					sz=nz;
				}
			}
			if (colortime=="Post Mandy Pre Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			//rotate back!!!
		if (theta!=3) {
			theta=atan2(sy+flip(sz));
			if (theta>0) {
				theta=(theta*spokes)/3;   // +pi/2  * 4/3
			} else {           //  (theta +pi/x)* 2/3*x
				theta=(theta*spokes)/3;
			}
			r1=sqrt(sqr(sy)+sqr(sz));
			sy=cos(theta)*r1;
			sz=sin(theta)*r1;  
		}
			
			//rotation around y axis, no y rotation
			
			foxtrot=(90-54.7356)/180*pi;
			whiskey= cos((foxtrot));
			tango= sin((foxtrot));
			//tango=whiskey;
			nx= sx  * whiskey - sz * tango;
			nz= sx  * tango     +  sz * whiskey;
			sx=nx;
			sz=nz;
				//rotation around z axis, no z rotation
			foxtrot=45/180*pi;
			whiskey= cos((foxtrot));
			tango= sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			ny=sx*tango+sy*whiskey;
			sx=nx;
			sy=ny;
			
			if (colortime=="Post Mandy Post Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			if (inversebailout) {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
				if (bail<(bailout^-1)) {
					bail=bailout+1;
				} else {
					 bail=0;
				}
				
			} else {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
			}
		} 
		else if (fractaltype=="Mandy Mag 1") {
			//mandy start  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			if (symmetrymode=="YZ Switch     very nice") {
				
				r2=(sqr(sx)+sqr(sy)+sqr(sz))^abs(n/2);
			
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz))));
				phi=atan2((sy)+flip((sz)));
				
				theta=n*theta;
				phi=n*phi;
				nx=r2*cos(theta);
				nz=(r2*cos(phi)*sin (theta));
				ny=(r2*sin(phi)*sin (theta));
			} else if (symmetrymode!="YZ Switch     very nice") {
				r2=(sqr(sx)+sqr(sy)+sqr(sz))^abs(n/2);
			
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz))));
				phi=atan2((sy)+flip((sz)));
				
				theta=n*theta;
				phi=n*phi;
				nx=r2*cos(theta);
				ny=r2*cos(phi)*sin (theta);
				nz=r2*sin(phi)*sin (theta);
			}
			if (Detail_Switch) {
				if (n==2 || n==6) {
					if (part_r(pixel)>0 && sx>sqrt(sqr(sy)+sqr(sz))) {
							nx=-nx;
						}
				} else if (n==3 || n==5  || n==7 || n==9) {
					if (sx>0) {
							nx=-nx;
						}
				}
			}
			if (juliaMode) {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;	
			} else {
				if(addyzpixel) {
						
						sx=nx+.5*part_r(pixel);
						
						sy=ny+.25*(part_i(pixel));
						sz=nz+.25*(part_j(pixel));
					} else  {
						sx=nx+part_r(pixel)*.5;
						sy=ny;
						sz=nz;
				}
			}
			if (colortime=="Post Mandy Pre Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
		
			//rotate back!!!
			
			//rotation around y axis    (xz plane)

			foxtrot=(90-54.7356)/180*pi;
			whiskey= cos((foxtrot));
			tango= sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			sz= sx  * tango     +  sz * whiskey;
			sx=nx;
				//rotation around z axis   (xy plane)
			foxtrot=45/180*pi;
			whiskey= cos((foxtrot));
			tango= sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			sy=sx*tango+sy*whiskey;
			sx=nx;
			if (colortime=="Post Mandy Post Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			// START MAG VS!!!!
			if (radswitch) {
					r=(abs(abs(sx)*sx+sy*abs(sy)+sz*abs(sz)));
					r1=(sqr(sx)*a+r)^(pixeln/2);
					r2=(sqr(sy)*a+r)^(pixeln/2);
					r3=(sqr(sz)*a+r)^(pixeln/2);
					r=sqrt(r);
				} else {
					r=(sqr(sx)+sqr(sy)+sqr(sz));
					r1=(sqr(sx)*a+r)^(pixeln/2);
					r2=(sqr(sy)*a+r)^(pixeln/2);
					r3=(sqr(sz)*a+r)^(pixeln/2);
					r=sqrt(r);
				}
			
			
			theta=atan2(abs(sx)*checkvar+flip(r));
			phi=atan2(abs(sy)*checkvar+flip(r));
			tango=atan2(abs(sz)*checkvar+flip(r));
			
			sx=r1*cos(theta*pixeln) +seed;
			sy=r2*cos(phi*pixeln) +seed;
			sz=r3*cos(tango*pixeln) +seed;
		
			if (colortime=="Post Mag Pre Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			// rotate towards mandy type

				//rotation around z axis   (xy plane)
			foxtrot=-45/180*pi;
			whiskey= cos((foxtrot));
			tango= sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			ny=sx*tango+sy*whiskey;
			sx=nx;
			sy=ny;
			
			//rotation around y axis     (xz plane)
			
			foxtrot=-(90-54.7356)/180*pi;
			whiskey= cos((foxtrot));
			tango= sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			nz= sx  * tango     +  sz * whiskey;
			sx=nx;
			sz=nz;
			
			if (colortime=="Post Mag Post Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			if (inversebailout) {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
				if (bail<(bailout^-1)) {
					bail=bailout+1;
				} else {
					 bail=0;
				}
				
			} else {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
			}
		}
		else if (fractaltype=="Mandy Mag 2 fast") {
			//mandy start  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
				
				r1=sqrt(sqr(sy)+sqr(sz));
			
				victor=complex(sx,r1)^n;
				bravo=(complex(sy,sz)/r1)^n;
				nx=part_r(victor);
				if (symmetrymode=="YZ Switch     very nice") {
					nz=part_i(victor)*part_r(bravo);
					ny=part_i(victor)*part_i(bravo);
				} else if (symmetrymode=="None") {
					ny=part_i(victor)*part_r(bravo);
					nz=part_i(victor)*part_i(bravo);
				} else if (symmetrymode=="YZ Root") {
					ny=part_i(victor)*part_r(bravo);
					nz=part_i(victor)*abs(part_i(bravo));
				} else if (symmetrymode=="YZ Switch (-z)    very nice") {
					nz=-part_i(victor)*part_r(bravo);
					ny=part_i(victor)*part_i(bravo);
				} else if (symmetrymode=="YZ and Ymode") {
					nz=part_i(victor)*part_r(bravo);
					ny=part_i(victor)*part_i(bravo);
					if (sy>abs(sz)) {nz=-nz;}
				} else if (symmetrymode=="Ymode") {
					ny=part_i(victor)*part_r(bravo);
					nz=part_i(victor)*part_i(bravo);
					if (sy>abs(sz)) {ny=-ny;}
				} else if (symmetrymode=="Ymode and Root") {
					ny=part_i(victor)*part_r(bravo);
					nz=part_i(victor)*abs(part_i(bravo));
					if (sy>abs(sz)) {ny=-ny;}
				} else if (symmetrymode=="Switch Root Ymode (-z)") {
					nz=-part_i(victor)*part_r(bravo);
					ny=part_i(victor)*abs(part_i(bravo));
					if (sy>abs(sz)) {nz=-nz;}
				} else if (symmetrymode=="Switch Ymode (-z)") {
					nz=-part_i(victor)*part_r(bravo);
					ny=part_i(victor)*part_i(bravo);
					if (sy>abs(sz)) {nz=-nz;}
				} else if (symmetrymode=="Switch Ymode AbsBra") {
					nz=part_i(victor)*abs(part_r(bravo));
					ny=part_i(victor)*abs(part_i(bravo));
					if (sy>abs(sz)) {nz=-nz;}
				} else if (symmetrymode=="Switch AbsBra") {
					nz=part_i(victor)*abs(part_r(bravo));
					ny=part_i(victor)*abs(part_i(bravo));
				} else if (symmetrymode=="Switch Ymode AbsBra (-z)") {
					nz=-part_i(victor)*abs(part_r(bravo));
					ny=part_i(victor)*abs(part_i(bravo));
					if (sy>abs(sz)) {nz=-nz;}
				} else if (symmetrymode=="Switch AbsBra (-z)") {
					nz=-part_i(victor)*abs(part_r(bravo));
					ny=part_i(victor)*abs(part_i(bravo));
				} else if (symmetrymode=="AbsBra (-z)") {
					ny=part_i(victor)*abs(part_r(bravo));
					nz=-part_i(victor)*abs(part_i(bravo));
					
				} else if (symmetrymode=="AbsBra") {
					ny=part_i(victor)*abs(part_r(bravo));
					nz=part_i(victor)*abs(part_i(bravo));
					
				} else if (symmetrymode=="Switch AbsALL") {
					nz=abs(part_i(victor)*(part_r(bravo)));
					ny=abs(part_i(victor)*(part_i(bravo)));
				} else if (symmetrymode=="Switch AbsALL (-z)") {
					nz=-abs(part_i(victor)*(part_r(bravo)));
					ny=abs(part_i(victor)*(part_i(bravo)));
				} else if (symmetrymode=="AbsALL (-z)") {
					ny=abs(part_i(victor)*(part_r(bravo)));
					nz=-abs(part_i(victor)*(part_i(bravo)));
					
				} else if (symmetrymode=="AbsALL") {
					ny=abs(part_i(victor)*abs(part_r(bravo)));
					nz=abs(part_i(victor)*abs(part_i(bravo)));
					
				}
			
			if (Detail_Switch) {
				if (n==2 || n==6) {
					if (part_r(pixel)>0 && sx>r1) {
							nx=-nx;
						}
				} else if (n==3 || n==5  || n==7 || n==9) {
					if (sx>0) {
							nx=-nx;
						}
				}
			}
			if (juliaMode) {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;	
			} else {
				if(addyzpixel) {
						
						sx=nx+.5*part_r(pixel);
						
						sy=ny+.25*(part_i(pixel));
						sz=nz+.25*(part_j(pixel));
					} else  {
						sx=nx+part_r(pixel)*.5;
						sy=ny;
						sz=nz;
				}
			}
		if (colortime=="Post Mandy Pre Rotation") {
			z=quaternion (sx,sy,sz,0);
			r=cabs(z);
			z=quaternion(r,sx,sy,sz);
		}
			//rotate back!!!
		if (theta!=3) {
			theta=atan2(sy+flip(sz));
			if (theta>0) {
				theta=(theta*spokes)/3;   // +pi/2  * 4/3
			} else {           //  (theta +pi/x)* 2/3*x
				theta=(theta*spokes)/3;
			}
			r1=sqrt(sqr(sy)+sqr(sz));
			sy=cos(theta)*r1;
			sz=sin(theta)*r1;  
		}
		
			//rotation around y axis, no y rotation
			//whiskey=54.7356/180*pi;
			//foxtrot=(90-54.7356)/180*pi;
			whiskey= sqrt(2/3); //cos((foxtrot));
			tango= sqrt(1/3); //sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			sz= sx  * tango     +  sz * whiskey;
			sx=nx;
			
				//rotation around z axis, no z rotation
			//foxtrot=45/180*pi;
			whiskey=sr2i;// cos((foxtrot));
			tango= whiskey; //sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			sy=sx*tango+sy*whiskey;
			sx=nx;
			
			if (colortime=="Post Mandy Post Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			// START MAG VS!!!!
			if (pixeln==2) {
				if (radswitch) {
					r=((sx)^2+(sy)^2+(sz)^2);
					nx=(sx^2+r)*(2/(1+ abs(abs(sy)*sy+abs(sz)*sz) / (sx^2*9) )-1) + seed;
					ny=(sy^2+r)*(2/(1+ abs(abs(sx)*sx+abs(sz)*sz) / (sy^2*9) )-1) +seed;
					sz=(sz^2+r)*(2/(1+ abs(abs(sx)*sx+abs(sy)*sy) / (sz^2*9) )-1) + seed;
				} else {
					sx=sqr(sx);
					sy=sqr(sy);
					sz=sqr(sz);
					r=((sx)+(sy)+(sz));
					if (r!=0) {
						nx=(sx+r)*(9*sx-sy-sz)/(9*sx+sy+sz)+seed;
						ny=(sy+r)*(9*sy-sx-sz)/(9*sy+sx+sz)+seed;
						sz=(sz+r)*(9*sz-sx-sy)/(9*sz+sx+sy)+seed;
					}
				} 
				sx=nx;
				sy=ny;
			} else {
				
				r=(sqr(sx)+sqr(sy)+sqr(sz))^abs(pixeln/2);
				if (radswitch) {
					r1=sqrt(abs(abs(sy)*sy+abs(sz)*sz));
					r2=sqrt(abs(abs(sx)*sx+abs(sz)*sz));
					r3=sqrt(abs(abs(sx)*sx+abs(sy)*sy));
				} else {
					r1=sqrt(sqr(sy)+sqr(sz));
					r2=sqrt(sqr(sx)+sqr(sz));
					r3=sqrt(sqr(sx)+sqr(sy));
				}
				a=pixeln+1;
				
				victor=complex(abs(sx)*a,r1);
				victor=(victor/cabs(victor))^pixeln;
				bravo=complex(abs(sy)*a,r2);
				bravo=(bravo/cabs(bravo))^pixeln;
				cramden=complex(abs(sz)*a,r3);
				cramden=(cramden/cabs(cramden))^pixeln;
				
				sx=(sqr(sx)+r)*victor +seed;
				sy=(sqr(sy)+r)*bravo +seed;
				sz=(sqr(sz)+r)*cramden +seed;
			/*    OLD STYLE  
				theta=atan2(abs(sx)*a+flip(r1));
				phi=atan2(abs(sy)*a+flip(r2));
				tango=atan2(abs(sz)*a+flip(r3));
				
				sx=(sqr(sx)+r)*cos(theta*pixeln) +seed;
				sy=(sqr(sy)+r)*cos(phi*pixeln) +seed;
				sz=(sqr(sz)+r)*cos(tango*pixeln) +seed;
			// OLD STYLE END      */
			}
			if (colortime=="Post Mag Pre Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			// rotate towards mandy type
		//rotation around z axis, no z rotation
			//foxtrot=-45/180*pi;
			whiskey= sr2i; //cos((foxtrot));
			tango= -whiskey;  //sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			sy=sx*tango+sy*whiskey;
			sx=nx;
			
			//rotation around y axis, no y rotation
			//foxtrot=-(90-54.7356)/180*pi;
			whiskey= sqrt(2/3);   //cos((foxtrot));
			tango= -sqrt(1/3);   //sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			sz= sx  * tango     +  sz * whiskey;
			sx=nx;	
			
		if (spokes!=3) {
			theta=atan2(sy+flip(sz));
			if (theta>0) {
				theta=(theta/spokes)*3;   // +pi/2  * 4/3
			} else {           //  (theta +pi/x)* 2/3*x
				theta=(theta/spokes)*3;
			}
			r1=sqrt(sqr(sy)+sqr(sz));
			sy=cos(theta)*r1;
			sz=sin(theta)*r1;
		}	
			if (colortime=="Post Mag Post Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			
			if (inversebailout) {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
				if (bail<(bailout^-1)) {
					bail=bailout+1;
				} else {
					 bail=0;
				}
				
			} else {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
			}
		}
		else if (fractaltype=="Mag Mandy 2 fast") {
			
			// START MAG VS!!!!
			if (pixeln==2) {
				if (radswitch) {
					r=((sx)^2+(sy)^2+(sz)^2);
					nx=(sx^2+r)*(2/(1+ abs(abs(sy)*sy+abs(sz)*sz) / (sx^2*9) )-1) + seed;
					ny=(sy^2+r)*(2/(1+ abs(abs(sx)*sx+abs(sz)*sz) / (sy^2*9) )-1) +seed;
					sz=(sz^2+r)*(2/(1+ abs(abs(sx)*sx+abs(sy)*sy) / (sz^2*9) )-1) + seed;
				} else {
					sx=sqr(sx);
					sy=sqr(sy);
					sz=sqr(sz);
					r=((sx)+(sy)+(sz));
				if (r!=0) {
					nx=(sx+r)*(9*sx-sy-sz)/(9*sx+sy+sz)+seed;
					ny=(sy+r)*(9*sy-sx-sz)/(9*sy+sx+sz)+seed;
					sz=(sz+r)*(9*sz-sx-sy)/(9*sz+sx+sy)+seed;
				} 
			}
				sx=nx;
				sy=ny;
			} else {
					r=(sqr(sx)+sqr(sy)+sqr(sz))^(pixeln/2);
				if (radswitch) {
					r1=sqrt(abs(abs(sy)*sy+abs(sz)*sz));
					r2=sqrt(abs(abs(sx)*sx+abs(sz)*sz));
					r3=sqrt(abs(abs(sx)*sx+abs(sy)*sy));
				} else {
					r1=sqrt(sqr(sy)+sqr(sz));
					r2=sqrt(sqr(sx)+sqr(sz));
					r3=sqrt(sqr(sx)+sqr(sy));
				}
				a=pixeln+1;
				victor=complex(abs(sx)*a,r1);
				victor=(victor/cabs(victor))^pixeln;
				bravo=complex(abs(sy)*a,r2);
				bravo=(bravo/cabs(bravo))^pixeln;
				cramden=complex(abs(sz)*a,r3);
				cramden=(cramden/cabs(cramden))^pixeln;
				
				sx=(sqr(sx)+r)*victor +seed;
				sy=(sqr(sy)+r)*bravo +seed;
				sz=(sqr(sz)+r)*cramden +seed;
			}
			if (colortime=="Post Mag Pre Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
				// rotate towards mandy type
					//rotation around z axis, no z rotation
			//foxtrot=-45/180*pi;
			whiskey= sr2i; //cos((foxtrot));
			tango= -whiskey;  //sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			sy=sx*tango+sy*whiskey;
			sx=nx;
			
			//rotation around y axis, no y rotation
			//foxtrot=-(90-54.7356)/180*pi;
			whiskey= sqrt(2/3);   //cos((foxtrot));
			tango= -sqrt(1/3);   //sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			sz= sx  * tango     +  sz * whiskey;
			sx=nx;	
			
		if (spokes!=3) {
			theta=atan2(sy+flip(sz));
			if (theta>0) {
				theta=(theta/spokes)*3;   // +pi/2  * 4/3
			} else {           //  (theta +pi/x)* 2/3*x
				theta=(theta/spokes)*3;
			}
			r1=sqrt(sqr(sy)+sqr(sz));
			sy=cos(theta)*r1;
			sz=sin(theta)*r1;
		}	
			if (colortime=="Post Mag Post Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			//mandy start  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
		
				r1=sqrt(sqr(sy)+sqr(sz));
			
				victor=complex(sx,r1)^n;
				bravo=(complex(sy,sz)/r1)^n;
				nx=part_r(victor);
				if (symmetrymode=="YZ Switch     very nice") {
					nz=part_i(victor)*part_r(bravo);
					ny=part_i(victor)*part_i(bravo);
				} else if (symmetrymode=="None") {
					ny=part_i(victor)*part_r(bravo);
					nz=part_i(victor)*part_i(bravo);
				} else if (symmetrymode=="YZ Root") {
					ny=part_i(victor)*part_r(bravo);
					nz=part_i(victor)*abs(part_i(bravo));
				} else if (symmetrymode=="YZ Switch (-z)    very nice") {
					nz=-part_i(victor)*part_r(bravo);
					ny=part_i(victor)*part_i(bravo);
				} else if (symmetrymode=="YZ and Ymode") {
					nz=part_i(victor)*part_r(bravo);
					ny=part_i(victor)*part_i(bravo);
					if (sy>abs(sz)) {nz=-nz;}
				} else if (symmetrymode=="Ymode") {
					ny=part_i(victor)*part_r(bravo);
					nz=part_i(victor)*part_i(bravo);
					if (sy>abs(sz)) {ny=-ny;}
				} else if (symmetrymode=="Ymode and Root") {
					ny=part_i(victor)*part_r(bravo);
					nz=part_i(victor)*abs(part_i(bravo));
					if (sy>abs(sz)) {ny=-ny;}
				} else if (symmetrymode=="Switch Root Ymode (-z)") {
					nz=-part_i(victor)*part_r(bravo);
					ny=part_i(victor)*abs(part_i(bravo));
					if (sy>abs(sz)) {nz=-nz;}
				} else if (symmetrymode=="Switch Ymode (-z)") {
					nz=-part_i(victor)*part_r(bravo);
					ny=part_i(victor)*part_i(bravo);
					if (sy>abs(sz)) {nz=-nz;}
				} else if (symmetrymode=="Switch Ymode AbsBra") {
					nz=part_i(victor)*abs(part_r(bravo));
					ny=part_i(victor)*abs(part_i(bravo));
					if (sy>abs(sz)) {nz=-nz;}
				} else if (symmetrymode=="Switch AbsBra") {
					nz=part_i(victor)*abs(part_r(bravo));
					ny=part_i(victor)*abs(part_i(bravo));
				} else if (symmetrymode=="Switch Ymode AbsBra (-z)") {
					nz=-part_i(victor)*abs(part_r(bravo));
					ny=part_i(victor)*abs(part_i(bravo));
					if (sy>abs(sz)) {nz=-nz;}
				} else if (symmetrymode=="Switch AbsBra (-z)") {
					nz=-part_i(victor)*abs(part_r(bravo));
					ny=part_i(victor)*abs(part_i(bravo));
				} else if (symmetrymode=="AbsBra (-z)") {
					ny=part_i(victor)*abs(part_r(bravo));
					nz=-part_i(victor)*abs(part_i(bravo));
					
				} else if (symmetrymode=="AbsBra") {
					ny=part_i(victor)*abs(part_r(bravo));
					nz=part_i(victor)*abs(part_i(bravo));
					
				} else if (symmetrymode=="Switch AbsALL") {
					nz=abs(part_i(victor)*(part_r(bravo)));
					ny=abs(part_i(victor)*(part_i(bravo)));
				} else if (symmetrymode=="Switch AbsALL (-z)") {
					nz=-abs(part_i(victor)*(part_r(bravo)));
					ny=abs(part_i(victor)*(part_i(bravo)));
				} else if (symmetrymode=="AbsALL (-z)") {
					ny=abs(part_i(victor)*(part_r(bravo)));
					nz=-abs(part_i(victor)*(part_i(bravo)));
					
				} else if (symmetrymode=="AbsALL") {
					ny=abs(part_i(victor)*abs(part_r(bravo)));
					nz=abs(part_i(victor)*abs(part_i(bravo)));
					
				}
			
			if (Detail_Switch) {
				if (n==2 || n==6) {
					if (part_r(pixel)>0 && sx>r1) {
							nx=-nx;
						}
				} else if (n==3 || n==5  || n==7 || n==9) {
					if (sx>0) {
							nx=-nx;
						}
				}
			}
			if (juliaMode) {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;	
			} else {
				if(addyzpixel) {
						if (part_r(pixel)<0) {
							sx=nx+part_r(pixel);
						} else {
							sx=nx+.5*part_r(pixel);
						}
						sy=ny+.25*(part_i(pixel));
						sz=nz+.25*(part_j(pixel));
					} else  {
						if (part_r(pixel)<0) {
							sx=nx+part_r(pixel);
						} else {
							sx=nx+part_r(pixel)*.5;
						}
					sy=ny;
					sz=nz;
				}
			}
		
		
			if (colortime=="Post Mandy Pre Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
		
			//rotate back!!!
		if (theta!=3) {
			theta=atan2(sy+flip(sz));
			if (theta>0) {
				theta=(theta*spokes)/3;   // +pi/2  * 4/3
			} else {           //  (theta +pi/x)* 2/3*x
				theta=(theta*spokes)/3;
			}
			r1=sqrt(sqr(sy)+sqr(sz));
			sy=cos(theta)*r1;
			sz=sin(theta)*r1;  
		}
		
			//rotation around y axis, no y rotation
			//whiskey=54.7356/180*pi;
			//foxtrot=(90-54.7356)/180*pi;
			whiskey= sqrt(2/3); //cos((foxtrot));
			tango= sqrt(1/3); //sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			sz= sx  * tango     +  sz * whiskey;
			sx=nx;
			
				//rotation around z axis, no z rotation
			//foxtrot=45/180*pi;
			whiskey=sr2i;// cos((foxtrot));
			tango= whiskey; //sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			sy=sx*tango+sy*whiskey;
			sx=nx;
			if (colortime=="Post Mandy Post Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			
			if (inversebailout) {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
				if (bail<(bailout^-1)) {
					bail=bailout+1;
				} else {
					 bail=0;
				}
				
			} else {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
			}
		}
		else if (fractaltype=="Mag Mandy Actual Pixel") {
			
			// START MAG VS!!!!
			
				r=(sqr(sx)+sqr(sy)+sqr(sz))^(pixeln/2);
				if (radswitch) {
					r1=sqrt(abs(abs(sy)*sy+abs(sz)*sz));
					r2=sqrt(abs(abs(sx)*sx+abs(sz)*sz));
					r3=sqrt(abs(abs(sx)*sx+abs(sy)*sy));
				} else {
					r1=sqrt(sqr(sy)+sqr(sz));
					r2=sqrt(sqr(sx)+sqr(sz));
					r3=sqrt(sqr(sx)+sqr(sy));
				}
				a=pixeln+1;
				theta=atan2(abs(sx)*a+flip(r1));
				phi=atan2(abs(sy)*a+flip(r2));
				tango=atan2(abs(sz)*a+flip(r3));
		
				sx=(sqr(sx)+r)*cos(theta*pixeln) +seed;
				sy=(sqr(sy)+r)*cos(phi*pixeln) +seed;
				sz=(sqr(sz)+r)*cos(tango*pixeln) +seed;
			if (colortime=="Post Mag Pre Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			
				// rotate towards mandy type
						
				//rotation around z axis, no z rotation
			//foxtrot=-45/180*pi;
			whiskey= sr2i; //cos((foxtrot));
			tango= -whiskey;  //sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			sy=sx*tango+sy*whiskey;
			sx=nx;
			
			//rotation around y axis, no y rotation
			//foxtrot=-(90-54.7356)/180*pi;
			whiskey= sqrt(2/3);   //cos((foxtrot));
			tango= -sqrt(1/3);   //sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			sz= sx  * tango     +  sz * whiskey;
			sx=nx;
			
		if (spokes!=3) {
			theta=atan2(sy+flip(sz));
			if (theta>0) {
				theta=(theta/spokes)*3;   // +pi/2  * 4/3
			} else {           //  (theta +pi/x)* 2/3*x
				theta=(theta/spokes)*3;
			}
			r1=sqrt(sqr(sy)+sqr(sz));
			sy=cos(theta)*r1;
			sz=sin(theta)*r1;
		}	
		
			if (colortime=="Post Mag Post Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			//mandy start  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			if (symmetrymode=="YZ Switch     very nice") {
				
				r2=(sqr(sx)+sqr(sy)+sqr(sz))^abs(n/2);
			
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz))));
				phi=atan2((sy)+flip((sz)));
				
				theta=n*theta;
				phi=n*phi;
				nx=r2*cos(theta);
				nz=(r2*cos(phi)*sin (theta));
				ny=(r2*sin(phi)*sin (theta));
			} else if (symmetrymode!="YZ Switch     very nice") {
				r2=(sqr(sx)+sqr(sy)+sqr(sz))^abs(n/2);
			
				theta=atan2((sx)+flip(sqrt(sqr(sy)+sqr(sz))));
				phi=atan2((sy)+flip((sz)));
				
				theta=n*theta;
				phi=n*phi;
				nx=r2*cos(theta);
				ny=r2*cos(phi)*sin (theta);
				nz=r2*sin(phi)*sin (theta);
			}
			if (Detail_Switch) {
				if (n==2 || n==6) {
					if (part_r(pixel)>0 && sx>sqrt(sqr(sy)+sqr(sz))) {
							nx=-nx;
						}
				} else if (n==3 || n==5  || n==7 || n==9) {
					if (sx>0) {
							nx=-nx;
						}
				}
			}
			if (juliaMode) {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;	
			} else {
				if(addyzpixel) {
						
						sx=nx+.5*part_r(pixel);
						
						sy=ny+.25*(part_i(pixel));
						sz=nz+.25*(part_j(pixel));
					} else  {
						sx=nx+part_r(pixel)*.5;
						sy=ny;
						sz=nz;
				}
			}
		
			if (colortime=="Post Mandy Pre Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			//rotate back!!!
		if (theta!=3) {
			theta=atan2(sy+flip(sz));
			if (theta>0) {
				theta=(theta*spokes)/3;   // +pi/2  * 4/3
			} else {           //  (theta +pi/x)* 2/3*x
				theta=(theta*spokes)/3;
			}
			r1=sqrt(sqr(sy)+sqr(sz));
			sy=cos(theta)*r1;
			sz=sin(theta)*r1;  
		}
		
			//rotation around y axis, no y rotation
			//whiskey=54.7356/180*pi;
			//foxtrot=(90-54.7356)/180*pi;
			whiskey= sqrt(2/3); //cos((foxtrot));
			tango= sqrt(1/3); //sin((foxtrot));

			nx= sx  * whiskey - sz * tango;
			sz= sx  * tango     +  sz * whiskey;
			sx=nx;
			
				//rotation around z axis, no z rotation
			//foxtrot=45/180*pi;
			whiskey=sr2i;// cos((foxtrot));
			tango= whiskey; //sin((foxtrot));
			
			nx=sx*whiskey-sy*tango;
			sy=sx*tango+sy*whiskey;
			sx=nx;

			if (colortime=="Post Mandy Post Rotation") {
				z=quaternion (sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			}
			if (inversebailout) {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
				if (bail<(bailout^-1)) {
					bail=bailout+1;
				} else {
					 bail=0;
				}
				
			} else {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
			}
		}
		//   Plain old MAG.... zzzZZZzzzzZZzzzZZz  snore....
		if (fractaltype=="mag vs xyz") {
		
			if (radswitch) {
					r=(abs(abs(sx)*sx+sy*abs(sy)+sz*abs(sz)));
					r1=sqrt(sqr(sx)*a+r);
					r2=sqrt(sqr(sy)*a+r);
					r3=sqrt(sqr(sz)*a+r);
					r=sqrt(r);
				} else {
					r=(sqr(sx)+sqr(sy)+sqr(sz));
					r1=sqrt(sqr(sx)*a+r);
					r2=sqrt(sqr(sy)*a+r);
					r3=sqrt(sqr(sz)*a+r);
					r=sqrt(r);
				}
		
		
			theta=atan2(abs(sx)*checkvar+flip(r));
			phi=atan2(abs(sy)*checkvar+flip(r));
			tango=atan2(abs(sz)*checkvar+flip(r));
	
			r1=r1^n;
			r2=r2^n;
			r3=r3^n;
		
		
			nx=r1*cos(theta*n);
			ny=r2*cos(phi*n);
			nz=r3*cos(tango*n);
	
			if (Detail_Switch) {
				if (n==2 || n==6) {
						if (pixelr>0 && sx*checkvar>r) {
							nx=-nx;
						}
						if (pixeli>0 && sy*checkvar>r) {
							ny=-ny;
						}
						if (pixelj>0 && sz*checkvar>r) {
							nz=-nz;
						}
				} else {
					if (pixelr>0 && sx>0) {
						nx=-nx;
					}
					if (pixeli>0 && sy>0) {
						ny=-ny;
					}
					if (pixelj>0 && sz>0) {
						nz=-nz;
					}
				}
			}

			if (juliaMode) {
					sx=nx+cr;
					sy=ny+ci;
					sz=nz+cj;
			} else {
					sx=nx+(pixelr);
					sy=ny+(pixeli);
					sz=nz+(pixelj);
			}
				z=quaternion(sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
			
			
		if (inversebailout) {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
				if (bail<(bailout^-1)) {
					bail=bailout+1;
				} else {
					 bail=0;
				}
				
			} else {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
			}
	
	} else if (fractaltype=="mag vs xyz 2") {
		
		
			r=(sqr(sx)+sqr(sy)+sqr(sz))^abs(pixeln/2);
		
			if (radswitch) {
				r1=sqrt(abs(abs(sy)*sy+sz*abs(sz)));
				r2=sqrt(abs(abs(sx)*sx+sz*abs(sz)));
				r3=sqrt(abs(abs(sx)*sx+sy*abs(sy)));
			} else {
				r1=sqrt(sqr(sy)+sqr(sz));
				r2=sqrt(sqr(sx)+sqr(sz));
				r3=sqrt(sqr(sx)+sqr(sy));
			}
			d=pixeln+1;
			theta=atan2(abs(sx)*d+flip(r1));
			phi=atan2(abs(sy)*d+flip(r2));
			tango=atan2(abs(sz)*d+flip(r3));
			
				nx=(sqr(sx)+r)*cos(theta*pixeln);
				ny=(sqr(sy)+r)*cos(phi*pixeln);
				nz=(sqr(sz)+r)*cos(tango*pixeln);
			
			if (Detail_Switch) {
				if (n==2 || n==6) {
						if (pixelr>0 && sx*d>r1) {
							nx=-nx;
						}
						if (pixeli>0 && sy*d>r2) {
							ny=-ny;
						}
						if (pixelj>0 && sz*d>r3) {
							nz=-nz;
						}
				} else if (n!=4 || n!=8) {
					if (sx>0) {
						nx=-nx;
					}
					if (sy>0) {
						ny=-ny;
					}
					if (sz>0) {
						nz=-nz;
					}
				}
			}
			

			if (juliaMode) {
						sx=nx+cr;
						sy=ny+ci;
						sz=nz+cj;
			} else {
					sx=nx+(pixelr);
					sy=ny+(pixeli);
					sz=nz+(pixelj);
			}
	
				z=quaternion(sx,sy,sz,0);
				r=cabs(z);
				z=quaternion(r,sx,sy,sz);
		
			if (inversebailout) {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
				if (bail<(bailout^-1)) {
					bail=bailout+1;
				} else {
					 bail=0;
				}
				
			} else {
				bail=sqr(sx)+sqr(sy)+sqr(sz);
			}
	} 
	 
	}

	bool bailout(void)
	{
		return(bail<bailout);
	}
	
	void description(void)
	{
		this.title="Mag xyz and combos";
	
		bailout.caption = "Bailout Value";
		bailout.default =16;
		bailout.hint = "Defines the bailout radius: As soon as a pixel falls outside a circle with this radius, the iteration stops.  Set high for these fractals as it smooths them out.";
		inversebailout.caption="Invert Bailout";
		fractaltype.caption="Formula";
		fractaltype.enum="Mag Mandy 2 fast\nMandy Mag 2 fast\nmag vs xyz\nMandy Mag 1\nMag Mandy 1\nmag vs xyz 2\nMag Mandy Actual Pixel";
		fractaltype.default=0;
		fractaltype.hint="Fast versions are z^2 only.  If you need help, go to fractalforums.com";
		colortime.caption="Color Trap Time";
		colortime.hint= "Pick when to trap orbits of fractal.  Either after Mandy section or after Mag section.";
		colortime.enum="Post Mandy Post Rotation\nPost Mandy Pre Rotation\nPost Mag Post Rotation\nPost Mag Pre Rotation";
		colortime.default=0;
		pixelmode.caption="Pixel Assignment";
		pixelmode.enum="+ no abs\n- no abs\n+y abs\n-y abs\n+z abs\n-z abs\n+y +z abs\n-y +z abs\n-y -z abs\n+y -z abs\n-x -y -z abs\n+x +y +z abs\nExp 2\nExp 3\nExp 3b";	
		pixelmode.hint="Pick absolute values of y (+ or -) to add symmetry to even n z^n fractals";
			symmetrymode.caption="Symmetry Mode";
		symmetrymode.enum="YZ Switch     very nice\nYZ Switch (-z)    very nice\nNone\nYZ Root\nYZ and Ymode\nYmode\nYmode and Root\nSwitch Root Ymode (-z)\nSwitch Ymode (-z)\nSwitch Ymode AbsBra\nSwitch AbsBra\nSwitch Ymode AbsBra (-z)\nSwitch AbsBra (-z)\nAbsBra (-z)\nAbsBra\nSwitch AbsALL (-z)\nSwitch AbsALL\nAbsALL (-z)\nAbsALL";
		symmetrymode.default=0;
		symmetrymode.visible=(fractaltype!="mag vs xyz 2"  &&  fractaltype!="mag vs xyz");
		seed.default=-.5;
		juliaMode.caption="Julia Mode";
		juliaMode.default=false;
		juliaMode.hint="If checked, Julia mode is enabled, otherwise Mandelbrot mode";
		Detail_Switch.caption="Detail Mode";
		Detail_Switch.default=false;
		Detail_Switch.hint="Yeah babe, it's a cosine thing.  Use for some fractals to change some details.";
		bmode.enum="Pi/2\nRoot 2\nGolden Ratio\nVariable";
		bmode.visible=(fractaltype=="mag vs xyz");
		bmode.hint="Change variable for calculation between golden ratio and square root of 2";
		checkvarset.caption="Multiplier";
		checkvarset.default=2;
		checkvarset.visible=(fractaltype=="mag vs xyz" && bmode=="Variable");
		checkvarset.hint="Set close to n for nice fractals, or for something interesting try -3, or other things";
		amode.caption="Calculation Mode";
		amode.visible=(fractaltype=="mag vs xyz");
		amode.visible=(fractaltype=="mag vs xyz");
		amode.hint="Change calculation mode for adding multiplier";
		amode.enum="b^(3-n)\nb*(n-1)^-1\nVariable";
		checkvarsetA.caption="Multiplier A";
		checkvarsetA.default=.1;
		checkvarsetA.visible=(amode=="Variable");
		checkvarsetA.hint="Set lower for higher n, higher for lower n.  ";
		
		radswitch.caption="Radius Switch";
		radswitch.hint="Not too interesting.  Maybe mess with z^2.";
		
		n.caption="Mandy z^n";
		n.default=2;
		n.hint="For non integer powers of n, the fast formulas are a bit slow due to how non-integer complex exponents are calculated";
		pixeln.caption="Mag z^n";
		pixeln.default=2;
		pixeln.hint="For non integer powers of n, the fast formulas are a bit slow due to how non-integer complex exponents are calculated";
		
		
		c.caption="Julia Seed";
		c.default=(0,0,0,0); /*(0.3,-0.44,-0.57,0.3); */
		c.hint="for Julia fractals set values 1,2 and 3 of this and c2";
		
		addyzpixel.caption="YZ Pixel";
		addyzpixel.default=false;
		addyzpixel.hint="Doesn't look that great this way, but it is canonical  <sp???>.";
		xchange.caption="Atan Switch";
		xchange.default=false;
		xchange.hint="Made a mistake in a formula, provides some variety if you want.";
		spokes.caption="Spokes";
		spokes.default=3;
		
		//   PIXEL STRETCH IS A LEGACY FUNCTION  You can add it back and mess with it
		//   by uncommenting this section and the section in the "init" part of the formula
		
		//pixelstretch.caption="Pixel Stretch Mode";
		//pixelstretch.enum="none\nStretch 1\nStretch 2";
		//pixelstretch.default=0;
		//pixelstretch.hint="Pixel Stretch Mode is a legacy function, and I haven't corrected it for use with the new formulas.  I suppose I should hide it for now."
		
		}
}
